# Source Code File 3. Code for PGLS analyses in Figure 6

library(sjPlot)
library(ggplot2)
library(dplyr)
library(ggpubr)
library(reshape2)
library("Hmisc") # Correlation analysis
library(corrplot) # Correlation plot
library(ape)
library(geiger)
library(nlme)
library(phytools)
library(rsq)

#pgls 
tree <- read.nexus("50Drosophila_spp.nex")
plot(tree)
mbCHCdataLongestSum <- read.csv("mbCHCdataLongestSummary.csv")
mbCHCdataLongestSum_female <- mbCHCdataLongestSum[mbCHCdataLongestSum$Sex == "Female",]

mbCHCdataLongestSum_female$logDesiccation <- log(mbCHCdataLongestSum_female$Desiccation)
mbCHCdataLongestSum_female$logLongLength <- log(mbCHCdataLongestSum_female$mbLongestLength)
mbCHCdataLongestSum_female$logLongQuantity <- log(mbCHCdataLongestSum_female$mbLongestQuantity)

pgls.long.mbCHC.female <- gls(logDesiccation ~ logLongLength * logLongQuantity, 
                              correlation = corBrownian(phy = tree, form=~SpeciesW),
                              data = mbCHCdataLongestSum_female, method = "ML")
summary(pgls.long.mbCHC.female)

# The longest. For Male. pgls. 
mbCHCdataLongestSum_male <- mbCHCdataLongestSum[mbCHCdataLongestSum$Sex == "Male",]

mbCHCdataLongestSum_male$logDesiccation <- log10(mbCHCdataLongestSum_male$Desiccation)
mbCHCdataLongestSum_male$logLongQuantity <- log10(mbCHCdataLongestSum_male$mbLongestQuantity)
mbCHCdataLongestSum_male$logLongLength <- log10(mbCHCdataLongestSum_male$mbLongestLength)

pgls.long.mbCHC.male <- gls(logDesiccation ~ logLongLength * logLongQuantity, 
                            correlation = corBrownian(phy = tree, form=~SpeciesW),
                            data = mbCHCdataLongestSum_male, method = "ML")
summary(pgls.long.mbCHC.male)





# Pagel's lambda for desiccation resistance 
female.desiccation <- as.matrix(data_pgls.sum.female$logDesiccation)
male.desiccation <- as.matrix(data_pgls.sum.male$logDesiccation)

row.names(female.desiccation) <- data_pgls.sum.female$Species
row.names(male.desiccation) <- data_pgls.sum.male$Species

phylosig(tree, female.desiccation, method="lambda",test=T, nsim=999)
phylosig(tree, male.desiccation, method="lambda",test=T, nsim=999)

# Pagel's lambda for mbCHC composition

library(Rphylopars)
library(phytools)
data <- read.csv("FinalCHC&Desiccation50Spp.csv")
phy <- read.nexus("50Drosophila_spp.nex")
data$logDesiccation <- log10(data$Desiccation)
data$mb26adjusted <- data$mb26/data$weight_ug
data$mb30adjusted <- data$mb30/data$weight_ug
data$mb32adjusted <- data$mb32/data$weight_ug
data$mb28adjusted <- data$mb28/data$weight_ug
data$mb24adjusted <- data$mb24/data$weight_ug

which(is.na(data)) # No missing value
data_male2 <- data[data$Sex == "Male",]
data_female2 <- data[data$Sex == "Female",]
data.female.mbCHC <- subset(data_female2,select = c(SpeciesW,mb24,mb26,mb28,
                                                    mb30,mb32))
data.male.mbCHC <- subset(data_male2,select = c(SpeciesW,mb24,mb26,mb28,
                                                mb30,mb32))
data.female.mbCHC <- data.female.mbCHC %>% 
  rename(species = SpeciesW)
data.male.mbCHC <- data.male.mbCHC %>% 
  rename(species = SpeciesW)


p.female.mbCHC <- phylopars(trait_data = data.female.mbCHC,tree = phy)
p.female.mbCHC # Estimated trait covariance
# Simulated trait covariance
p.female.mbCHC$anc_recon

write.csv(p.female.mbCHC$anc_recon,"female_mbCHC_ancestral_corrected.csv")

p_lambda.female <- phylopars(trait_data = data.female.mbCHC,tree = phy,model = "lambda")
p_lambda.female


p.male.mbCHC <- phylopars(trait_data = data.male.mbCHC,tree = phy,
                          pheno_error = TRUE,phylo_correlated = TRUE,pheno_correlated = TRUE)
p.male.mbCHC # Estimated trait covariance
# Simulated trait covariance
p.male.mbCHC$anc_recon
write.csv(p.male.mbCHC$anc_recon,"male_mbCHC_ancestral_corrected.csv")

# prediction variance


# estimate Pagel's lambda for mbCHCs in males
p_lambda.male <- phylopars(trait_data = data.male.mbCHC,tree = phy,model = "lambda",
                           pheno_error = TRUE,phylo_correlated = TRUE,pheno_correlated = TRUE)
p_lambda.male # Estimated trait covariance and Pagel's lambda

# Now we fit a model assuming a star phylogeny, 
#which is the null hypothesis when testing for significant 
#phylogenetic signal under Pagel's lambda (i.e., lambda=0).

p_star.male <- phylopars(trait_data = data.male.mbCHC,tree = phy,model = "star")
p_star.male # Estimated trait covariance, fixed Pagel's lambda = 0

#Now we use the likelihood ratio to test for phylogenetic signal:
# 2*(logLik_alt - logLik_null)
# If significant, suggesting significant phylogenetic signal in the phylogenetic residuals (Revell 2010)

chi_square.male.mbCHCs <- as.double(2*(logLik(p_lambda.male) - logLik(p_star.male))) 
degrees_freedom.male.mbCHCs <- p_lambda.male$npars - p_star.male$npars # df = difference in # model parameters
pchisq(q = chi_square.male.mbCHCs,df = degrees_freedom.male.mbCHCs,lower.tail = FALSE) # p-value

# Test comparisons with other evolutionary model (non-Brownian)
# Ornstein-Uhlenbeck (Hansen 1997) and Early-Burst (Harmon et al. 2010). 

p_EB.male <- phylopars(trait_data = data.male.mbCHC,tree = phy,model = "EB")

AIC(p_lambda.male)
AIC(p_EB.male)
# Comparison suggests brownian model is better.

plot(phy)
nodelabels(frame="none",adj=c(1.1,-0.4))
write.csv(p_BM$anc_recon,"mbCHCancestralState.csv")
